<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
/**
 *
 * Skill About Widget .
 *
 */
class Techbiz_Skill_About extends Widget_Base {

	public function get_name() {
		return 'techbizskillabout';
	}

	public function get_title() {
		return __( 'Skill About', 'techbiz' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'techbiz' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'skill_about_section',
			[
				'label' 	=> __( 'Skill About', 'techbiz' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		
		$this->add_control(
			'skill_title_text',
			[
				'label' 	=> __( 'Skill Title text', 'techbiz' ),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'   => __( 'Growing Business', 'techbiz' ),
			]
		);
        
        $this->add_control(
			'progress_bar_width',
			[
				'label' 		=> __( 'Bar Width', 'techbiz' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ '%' ],
				'range' 		=> [
					'%' 			=> [
						'min' 			=> 0,
						'max' 			=> 100,
						'step'			=> 5,
					],
				],
				'default' 	=> [
					'unit' 		=> '%',
					'size' 		=> 41,
				],
			]
		);
        
		$this->add_control(
			'skill_subtitle_text',
			[
				'label' 	=> __( 'Skill Subtitle Text', 'techbiz' ),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'   => __( 'The startup phase is the riskiest stage of a business, but there are ways to break...', 'techbiz' ),
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'skill_about_style_section',
			[
				'label' => __( 'Skill About Style', 'techbiz' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
			'skill_about_number_color',
			[
				'label' 	=> __( 'Skill About Number Color', 'techbiz' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .skill-about .skill-percentage' => 'color: {{VALUE}}!important',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'skill_about_number_typography',
				'label' 	=> __( 'Skill About Number Typography', 'techbiz' ),
                'selector' 	=> '{{WRAPPER}} .skill-about .skill-percentage',
			]
		);

        $this->add_control(
			'skill_about_title_color',
			[
				'label' 	=> __( 'Skill About Title Color', 'techbiz' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .skill-about .skill-title' => 'color: {{VALUE}}!important',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'skill_about_title_typography',
				'label' 	=> __( 'Skill About Title Typography', 'techbiz' ),
                'selector' 	=> '{{WRAPPER}} .skill-about .skill-title',
			]
		);
        
        $this->add_control(
			'skill_about_subtitle_color',
			[
				'label' 	=> __( 'Skill About SubTitle Color', 'techbiz' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .skill-about .skill-text' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'skill_about_subtitle_typography',
				'label' 	=> __( 'Skill About SubTitle Typography', 'techbiz' ),
                'selector' 	=> '{{WRAPPER}} .skill-about .skill-text',
			]
		);

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        echo '<div class="skill-about">';
            if( ! empty( $settings['progress_bar_width']['size'] ) ){
                echo '<div class="skill-percentage text-white">'.esc_html( $settings['progress_bar_width']['size'] ).'%</div>';
            }
            if( ! empty( $settings['skill_title_text'] ) ){
                echo '<h3 class="skill-title text-white">'.esc_html( $settings['skill_title_text'] ).'</h3>';
            }
            echo '<div class="progress">';
                echo '<div class="progress-bar" role="progressbar" style="width: '.esc_attr( $settings['progress_bar_width']['size'] ).'%" aria-valuenow="'.esc_attr( $settings['progress_bar_width']['size'] ).'" aria-valuemin="0" aria-valuemax="100"></div>';
            echo '</div>';
            if( ! empty( $settings['skill_subtitle_text'] ) ){
                echo '<p class="skill-text text-light2">'.esc_html( $settings['skill_subtitle_text'] ).'</p>';
            }
        echo '</div>';

	}

}