<?php
/**
 * @Packge     : Techbiz
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */


// Blocking direct access
if( ! defined( 'ABSPATH' ) ) {
    exit;
}

function techbiz_core_essential_scripts( ) {
    wp_enqueue_script('techbiz-ajax',TECHBIZ_PLUGDIRURI.'assets/js/techbiz.ajax.js',array( 'jquery' ),'1.0',true);
    wp_localize_script(
    'techbiz-ajax',
    'techbizajax',
        array(
            'action_url' => admin_url( 'admin-ajax.php' ),
            'nonce'	     => wp_create_nonce( 'techbiz-nonce' ),
        )
    );
}

add_action('wp_enqueue_scripts','techbiz_core_essential_scripts');


// techbiz Section subscribe ajax callback function
add_action( 'wp_ajax_techbiz_subscribe_ajax', 'techbiz_subscribe_ajax' );
add_action( 'wp_ajax_nopriv_techbiz_subscribe_ajax', 'techbiz_subscribe_ajax' );

function techbiz_subscribe_ajax( ){
  $apiKey = techbiz_opt('techbiz_subscribe_apikey');
  $listid = techbiz_opt('techbiz_subscribe_listid');
   if( ! wp_verify_nonce($_POST['security'], 'techbiz-nonce') ) {
    echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('You are not allowed.', 'techbiz').'</div>';
   }else{
       if( !empty( $apiKey ) && !empty( $listid )  ){
           $MailChimp = new DrewM\MailChimp\MailChimp( $apiKey );

           $result = $MailChimp->post("lists/{$listid}/members",[
               'email_address'    => esc_attr( $_POST['sectsubscribe_email'] ),
               'status'           => 'subscribed',
           ]);

           if ($MailChimp->success()) {
               if( $result['status'] == 'subscribed' ){
                   echo '<div class="alert alert-success mt-2" role="alert">'.esc_html__('Thank you, you have been added to our mailing list.', 'techbiz').'</div>';
               }
           }elseif( $result['status'] == '400' ) {
               echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('This Email address is already exists.', 'techbiz').'</div>';
           }else{
               echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('Sorry something went wrong.', 'techbiz').'</div>';
           }
        }else{
           echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('Apikey Or Listid Missing.', 'techbiz').'</div>';
        }
   }

   wp_die();

}