<?php

    use Elementor\Controls_Manager;
    use Elementor\Group_Control_Typography;
    use Elementor\Plugin;
    use Elementor\Repeater;
    use Elementor\Utils;
    use Elementor\Widget_Base;

/**
 *
 * Gallery Widget .
 *
 */
class Bizino_New_Gallery extends Widget_Base{

    public function get_name(){
        return 'bizinonewgallery';
    }

    public function get_title(){
        return __('Bizino New Gallery', 'bizino');
    }

    public function get_icon(){
        return 'eicon-code';
    }

    public function get_categories(){
        return ['bizino'];
    }

    protected function register_controls(){

        $this->start_controls_section(
            'gallery_section',
            [
                'label'     => __('Gallery', 'bizino'),
                'tab'       => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'gallery_image',
            [
                'label'     => __('Gallery image', 'bizino'),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url'       => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'gallery_image_url', [
                'label'         => __('Gallery Image Url', 'bizino'),
                'type'          => Controls_Manager::URL,
                'placeholder'   => __('https://your-link.com', 'bizino'),
                'default'       => [
                    'url'    => '#',
                ],
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'image_title', [
                'label'         => __('Main Title', 'bizino'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __('Branding Marketing', 'bizino'),
                'label_block'   => true,
            ]
        );
        
        $repeater->add_control(
            'image_subtitle', [
                'label'         => __('Title 2', 'bizino'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __('Support', 'bizino'),
                'label_block'   => true,
            ]
        );
        
        $repeater->add_control(
            'gallery_icon_image',
            [
                'label'     => __('Gallery Icon image', 'bizino'),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url'       => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        
        $this->add_control(
            'slides',
            [
                'label' => __('Slides', 'bizino'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image_title'       => __( 'Estate Planning', 'bizino'),
                        'image_subtitle'    => __( 'Chief Operating', 'bizino'),
                    ],
                    [
                        'image_title'       => __( 'Web Development', 'bizino'),
                        'image_subtitle'    => __( 'Chief Operating', 'bizino'),
                    ],
                    [
                        'image_title'       => __( 'Product Design', 'bizino'),
                        'image_subtitle'    => __( 'Latest Trend', 'bizino'),
                    ],
                    [
                        'image_title'       => __( 'Online Growth', 'bizino'),
                        'image_subtitle'    => __( 'UI/UX Explain', 'bizino'),
                    ],
                    [
                        'image_title'       => __( 'TBC Pvt. Limited', 'bizino'),
                        'image_subtitle'    => __( 'Managment', 'bizino'),
                    ],
                    [
                        'image_title'       => __( 'Vecuro Consulation', 'bizino'),
                        'image_subtitle'    => __( 'Top Rated', 'bizino'),
                    ],
                    [
                        'image_title'       => __( 'DBBL Bank Limited', 'bizino'),
                        'image_subtitle'    => __( 'Security Update', 'bizino'),
                    ],
                    [
                        'image_title'       => __( 'LKK Business Care', 'bizino'),
                        'image_subtitle'    => __( 'Consulting Power', 'bizino'),
                    ],
                ],
                'title_field' => '{{{ image_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'gallery_title_style_section',
            [
                'label' => __('Title', 'bizino'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'gallery_title_color',
            [
                'label' => __('Title Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .gallery-style4 .gallery-title' => 'color: {{VALUE}}!important',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'gallery_title_typography',
                'label' => __('Title Typography', 'bizino'),
                'selector' => '{{WRAPPER}} .gallery-style4 .gallery-title',
            ]
        );

        $this->add_responsive_control(
            'gallery_title_margin',
            [
                'label' => __('Title Margin', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .gallery-style4 .gallery-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'gallery_subtitle_color',
            [
                'label' => __('Gallery Subtitle Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .gallery-style4 .gallery-degi' => 'color: {{VALUE}}!important',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'gallery_subtitle_typography',
                'label' => __('Gallery Subtitle Typography', 'bizino'),
                'selector' => '{{WRAPPER}} .gallery-style4 .gallery-degi',
            ]
        );


        $this->end_controls_section();


    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();
        
        if( ! empty( $settings['slides'] ) ){
            echo '<div class="bizino-new-gallery">';
                echo '<div class="container-fluid px-0">';
                    echo '<div class="row gx-2 gy-gx mb-2">';
                        foreach( $settings['slides'] as $singleslide ){
                            echo '<div class="col-sm-6 col-xl-4 col-xxl-3">';
                                echo '<div class="gallery-style4">';
                                    if( ! empty( $singleslide['gallery_image']['url'] ) ){
                                        echo '<div class="gallery-img">';
                                            echo '<a href="'.esc_url( $singleslide['gallery_image_url']['url'] ).'">';
                                                echo techbiz_img_tag( array(
                                                    'url'   => esc_url( $singleslide['gallery_image']['url'] ),
                                                ) );
                                            echo '</a>';
                                        echo '</div>';
                                    }
                                    echo '<div class="gallery-content">';
                                        if( ! empty( $singleslide['image_title'] ) ){
                                            echo '<h3 class="gallery-title">'.esc_html( $singleslide['image_title'] ).'</h3>';
                                        }
                                        if( ! empty( $singleslide['image_subtitle'] ) ){
                                            echo '<span class="gallery-degi">'.esc_html( $singleslide['image_subtitle'] ).'</span>';
                                        }
                                        if( ! empty( $singleslide['gallery_icon_image']['url'] ) ){
                                            echo '<a href="'.esc_url( $singleslide['gallery_image_url']['url'] ).'" class="gallery-btn">';
                                                echo techbiz_img_tag( array(
                                                    'url'   => esc_url( $singleslide['gallery_icon_image']['url'] ),
                                                ) );
                                            echo '</a>';
                                        }
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        }
    }
}

Plugin::instance()->widgets_manager->register(new Bizino_New_Gallery());