<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
/**
 *
 * Image Widget .
 *
 */
class Techbiz_Image_Box extends Widget_Base {

	public function get_name() {
		return 'techbizimagebox';
	}

	public function get_title() {
		return __( 'Image Box', 'techbiz' );
	}


	public function get_icon() {
		return 'eicon-code';
    }


	public function get_categories() {
		return [ 'techbiz' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'image_section',
			[
				'label' 	=> __( 'Image Box', 'techbiz' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'image_box_style',
			[
				'label'     => __( 'Image Box Style', 'techbiz' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => '1',
				'options'   => [
					'1'            => __( 'Style One', 'techbiz' ),
					'2'            => __( 'Style Two', 'techbiz' ),
					'3'            => __( 'Style Three', 'techbiz' ),
					'4'            => __( 'Style Four', 'techbiz' ),
					'5'            => __( 'Style Five', 'techbiz' ),
					'6'            => __( 'Style Six', 'techbiz' ),
					'7'            => __( 'Style Seven', 'techbiz' ),
					'8'            => __( 'Style Eight', 'techbiz' ),
				],
			]
		);

        $this->add_control(
			'image_one',
			[
				'label' 		=> __( 'Choose Image', 'techbiz' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
			'image_two',
			[
				'label' 		=> __( 'Choose Image', 'techbiz' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'     => [ 'image_box_style' => ['1','2','3','4','5','7'] ]
			]
		);

        $this->add_control(
			'image_three',
			[
				'label' 		=> __( 'Choose Image', 'techbiz' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
                'condition'     => [ 'image_box_style' => ['5','7'] ]
			]
		);

        $this->add_control(
			'video_link',
			[
				'label' 		=> __( 'Video Link', 'techbiz' ),
				'type' 			=> Controls_Manager::URL,
                'placeholder' 	=> __( 'https://your-link.com', 'techbiz' ),
                'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
                'condition'     => [ 'image_box_style' => ['1','2','6','7'] ]
			]
        );

		$this->add_control(
			'award_number',
			[
				'label' 		=> __( 'Award Numbers', 'techbiz' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( '100+', 'techbiz' ),
				'placeholder' 	=> __( 'Type Award Number', 'techbiz' ),
				'condition'     => [ 'image_box_style' => '3' ]
			]
		);
		
		$this->add_control(
			'phone_number',
			[
				'label' 		=> __( 'Phone Numbers', 'techbiz' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( '100+', 'techbiz' ),
				'placeholder' 	=> __( 'Type Award Number', 'techbiz' ),
				'condition'     => [ 'image_box_style' => '8' ]
			]
		);

		$this->add_control(
			'award_text',
			[
				'label' 		=> __( 'Award Text', 'techbiz' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Awards we won', 'techbiz' ),
				'placeholder' 	=> __( 'Type Award Text', 'techbiz' ),
				'condition'     => [ 'image_box_style' => '3' ]
			]
		);

        $this->end_controls_section();


        $this->start_controls_section(
			'image_style_section',
			[
				'label' 	=> __( 'Image Style', 'techbiz' ),
                'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );



		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['image_box_style'] == '1' ){
            echo '<div class="img-box1">';
				if( ! empty( $settings['image_one']['url'] ) ){
                	echo '<div class="img-1">';
                    	echo techbiz_img_tag( array(
							'url'	=> esc_url( $settings['image_one']['url'] ),
						) );
                	echo '</div>';
				}
                echo '<div class="img-2">';
					if( ! empty( $settings['image_two']['url'] ) ){
						echo techbiz_img_tag( array(
							'url'	=> esc_url( $settings['image_two']['url'] ),
						) );
					}
					if( ! empty( $settings['video_link']['url'] ) ){
	                    echo '<a class="play-btn popup-video style2 position-center" href="'.esc_url( $settings['video_link']['url'] ).'"><i class=""><i class="fas fa-play"></i></i></a>';
					}
                echo '</div>';
            echo '</div>';
        }elseif( $settings['image_box_style'] == '2' ){
            echo '<div class="img-box2">';
				if( ! empty( $settings['image_one']['url'] ) ){
	                echo '<div class="img-1">';
						echo techbiz_img_tag( array(
							'url'	=> esc_url( $settings['image_one']['url'] ),
						) );
					echo '</div>';
				}
                echo '<div class="img-2">';
					if( ! empty( $settings['image_two']['url'] ) ){
						echo techbiz_img_tag( array(
							'url'	=> esc_url( $settings['image_two']['url'] ),
						) );
					}
					if( ! empty( $settings['video_link']['url'] ) ){
						echo '<a class="play-btn popup-video style3 position-center" href="'.esc_url( $settings['video_link']['url'] ).'"><i class=""><i class="fas fa-play"></i></i></a>';
					}
				echo '</div>';
            echo '</div>';
        }elseif( $settings['image_box_style'] == '3' ){
            echo '<div class="img-box3">';
				if( ! empty( $settings['image_one']['url'] ) ){
	                echo '<div class="img-1">';
						echo techbiz_img_tag( array(
							'url'	=> esc_url( $settings['image_one']['url'] ),
						) );
					echo '</div>';
				}
				if( ! empty( $settings['image_two']['url'] ) ){
	                echo '<div class="img-2">';
						echo techbiz_img_tag( array(
							'url'	=> esc_url( $settings['image_two']['url'] ),
						) );
					echo '</div>';
				}
                echo '<div class="award-box">';
                    echo '<div class="award-box__shape"></div>';
                    echo '<div class="award-box__icon"><i class="fal fa-award"></i></div>';
                    echo '<div class="media-body">';
						if( ! empty( $settings['award_number'] ) ){
                        	echo '<p class="award-box__number">'.esc_html( $settings['award_number'] ).'</p>';
						}
						if( ! empty( $settings['award_text'] ) ){
	                        echo '<div class="award-box__text">'.esc_html( $settings['award_text'] ).'</div>';
						}
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        }elseif( $settings['image_box_style'] == '4' ){
            echo '<div class="img-box4">';
				if( ! empty( $settings['image_one']['url'] ) ){
	                echo '<div class="img-1">';
						echo techbiz_img_tag( array(
							'url'	=> esc_url( $settings['image_one']['url'] ),
						) );
					echo '</div>';
				}
				if( ! empty( $settings['image_two']['url'] ) ){
	                echo '<div class="img-2">';
						echo techbiz_img_tag( array(
							'url'	=> esc_url( $settings['image_two']['url'] ),
						) );
					echo '</div>';
				}
            echo '</div>';
        }elseif( $settings['image_box_style'] == '5' ){
            echo '<div class="img-box5">';
				if( ! empty( $settings['image_one']['url'] ) ){
					echo '<div class="img-1">';
						echo techbiz_img_tag( array(
							'url'	=> esc_url( $settings['image_one']['url'] ),
						) );
					echo '</div>';
				}
                echo '<div class="img-bottom">';
					if( ! empty( $settings['image_two']['url'] ) ){
						echo '<div class="img-2">';
							echo techbiz_img_tag( array(
								'url'	=> esc_url( $settings['image_two']['url'] ),
							) );
						echo '</div>';
					}
					if( ! empty( $settings['image_three']['url'] ) ){
	                    echo '<div class="img-3">';
							echo techbiz_img_tag( array(
								'url'	=> esc_url( $settings['image_three']['url'] ),
							) );
						echo '</div>';
					}
                echo '</div>';
                echo '<div class="shape1"></div>';
            echo '</div>';
        }elseif( $settings['image_box_style'] == '6' ){
			echo '<div class="img-box8">';
				if( ! empty( $settings['image_one']['url'] ) ){
					echo '<div class="img-1">';
						echo techbiz_img_tag( array(
							'url'	=> esc_url( $settings['image_one']['url'] ),
						) );
					echo '</div>';
				}
				if( ! empty( $settings['video_link']['url'] ) ){
					echo '<a class="play-btn popup-video style5" href="'.esc_url( $settings['video_link']['url'] ).'"><i class=""><i class="fas fa-play"></i></i></a>';
				}
			echo '</div>';
		}elseif( $settings['image_box_style'] == '7' ){
			echo '<div class="img-box9">';
				if( ! empty( $settings['image_one']['url'] ) ){
					echo '<div class="img-1">';
						echo techbiz_img_tag( array(
							'url'	=> esc_url( $settings['image_one']['url'] ),
						) );
					echo '</div>';
				}
				if( ! empty( $settings['image_two']['url'] ) ){
					echo '<div class="img-2">';
						echo techbiz_img_tag( array(
							'url'	=> esc_url( $settings['image_two']['url'] ),
						) );
					echo '</div>';
				}
				echo '<div class="img-3">';
					if( ! empty( $settings['image_three']['url'] ) ){
						echo techbiz_img_tag( array(
							'url'	=> esc_url( $settings['image_three']['url'] ),
						) );
					}
					if( ! empty( $settings['video_link']['url'] ) ){
						echo '<a class="play-btn style6 position-center popup-video" href="'.esc_url( $settings['video_link']['url'] ).'"><i class=""><i class="fas fa-play"></i></i></a>';
					}
				echo '</div>';
			echo '</div>';
		}elseif( $settings['image_box_style'] == '8' ){
			echo '<div class="img-box10">';
				if( ! empty( $settings['image_one']['url'] ) ){
					echo techbiz_img_tag( array(
						'url'	=> esc_url( $settings['image_one']['url'] ),
					) );
				}
				echo '<a href="tel:'.esc_attr( $settings['phone_number'] ).'" class="icon-btn style4"><i class="fas fa-phone-alt"></i></a>';
			echo '</div>';
		}
	}
}