<?php
/**
 * Plugin Name: Techbiz Core
 * Description: This is a helper plugin of techbiz theme
 * Version:     2.0.1
 * Author:      Vecurosoft
 * License:     GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Domain Path: /languages
 * Text Domain: techbiz
 */
 // Blocking direct access
if( ! defined( 'ABSPATH' ) ) {
    exit();
}

// Define Constant
define( 'TECHBIZ_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'TECHBIZ_PLUGIN_INC_PATH', plugin_dir_path( __FILE__ ) . 'inc/' );
define( 'TECHBIZ_PLUGIN_CMB2EXT_PATH', plugin_dir_path( __FILE__ ) . 'cmb2-ext/' );
define( 'TECHBIZ_PLUGIN_WIDGET_PATH', plugin_dir_path( __FILE__ ) . 'inc/widgets/' );
define( 'TECHBIZ_PLUGDIRURI', plugin_dir_url( __FILE__ ) );
define( 'TECHBIZ_ADDONS', plugin_dir_path( __FILE__ ) .'addons/' );
define( 'TECHBIZ_CORE_PLUGIN_TEMP', plugin_dir_path( __FILE__ ) .'techbiz-template/' );

// load textdomain
load_plugin_textdomain( 'techbiz', false, basename( dirname( __FILE__ ) ) . '/languages' );

//include file.
require_once TECHBIZ_PLUGIN_INC_PATH .'techbizcore-functions.php';
require_once TECHBIZ_PLUGIN_INC_PATH . 'MCAPI.class.php';
require_once TECHBIZ_PLUGIN_INC_PATH .'techbizajax.php';
require_once TECHBIZ_PLUGIN_INC_PATH .'builder/builder.php';

require_once TECHBIZ_PLUGIN_CMB2EXT_PATH . 'cmb2ext-init.php';

//Widget
require_once TECHBIZ_PLUGIN_WIDGET_PATH . 'recent-post-widget.php';
require_once TECHBIZ_PLUGIN_WIDGET_PATH . 'social-widget.php';
require_once TECHBIZ_PLUGIN_WIDGET_PATH . 'about-us-widget.php';
require_once TECHBIZ_PLUGIN_WIDGET_PATH . 'newsletter-widget.php';
// require_once TECHBIZ_PLUGIN_WIDGET_PATH . 'footer-map.php';

//addons
require_once TECHBIZ_ADDONS . 'addons.php';