<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Widget_Base;

/**
 *
 * Pricing Plan Widget .
 *
 */
class Bizino_Pricing_Plan extends Widget_Base{

    public function get_name(){
        return 'bizinopricingplan';
    }

    public function get_title(){
        return __( 'Pricing Plan', 'bizino' );
    }

    public function get_icon(){
        return 'eicon-code';
    }

    public function get_categories(){
        return ['bizino'];
    }

    protected function register_controls(){

        $this->start_controls_section(
            'pricingplan_section',
            [
                'label' => __( 'Pricing Plan', 'bizino' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'pricing_plan_image',
            [
                'label'     => __( 'Pricing Plan image', 'bizino' ),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url'       => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'pricingplan_name', [
                'label'         => __( 'Pricing Plan Name', 'bizino'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __( 'Basic Plan', 'bizino'),
                'label_block'   => true,
            ]
        );
        $this->add_control(
            'pricingplan_subtext', [
                'label'         => __( 'Pricing Plan Subtext', 'bizino' ),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __( 'PERFECT TO GET STARTED', 'bizino' ),
                'label_block'   => true,
            ]
        );
        $this->add_control(
            'pricingplan_amount', [
                'label'         => __('Pricing Plan Amount', 'bizino'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __( '$13', 'bizino' ),
                'label_block'   => true,
            ]
        );
        $this->add_control(
            'pricingplan_button_text', [
                'label'         => __('Pricing Plan Button Text', 'bizino'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __( 'try 7 days for free', 'bizino' ),
                'label_block'   => true,
            ]
        );
        $this->add_control(
			'pricingplan_button_url',
			[
				'label'     => __( 'Link', 'bizino' ),
				'type'      => \Elementor\Controls_Manager::URL,
				'options'   => [ 'url', 'is_external', 'nofollow' ],
				'default'   => [
					'url'           => '#',
					'is_external'   => true,
					'nofollow'      => true,
				],
				'label_block' => true,
			]
		);
        $this->add_control(
            'pricingplan_desc_sub', [
                'label'         => __( 'Pricing Plan Subtitle', 'bizino' ),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __( 'Includes Plan :', 'bizino' ),
                'label_block'   => true,
            ]
        );
        $this->add_control(
            'pricingplan_description', [
                'label'         => __( 'Pricing Plan Description', 'bizino' ),
                'type'          => Controls_Manager::WYSIWYG,
                'default'       => __( 'Set Description', 'bizino' ),
                'label_block'   => true,
            ]
        );
        
        $this->add_control(
            'make_active',
            [
                'label'         => esc_html__( 'Make Active?', 'bizino' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'bizino' ),
                'label_off'     => esc_html__( 'No', 'bizino' ),
                'return_value'  => 'yes',
                'default'       => 'yes',
            ]
        );
        
        $this->end_controls_section();
        
        $this->start_controls_section(
            'general_styling',
            [
                'label' => __('General Styling', 'bizino'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'pricing_box_bg',
            [
                'label'     => __('Pricing Box Bg Color', 'bizino'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .package-style3' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'title_styling',
            [
                'label' => __('Title Styling', 'bizino'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'pricingplan_title_color',
            [
                'label' => __('Title Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .package-style3 .package-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'pricingplan_title_typography',
                'label' => __('Title Typography', 'bizino'),
                'selector' => '{{WRAPPER}} .package-style3 .package-title'
            ]
        );

        $this->add_responsive_control(
            'pricingplan_title_margin',
            [
                'label' => __('Title Margin', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .package-style3 .package-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'pricingplan_title_padding',
            [
                'label' => __('Title Padding', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .package-style3 .package-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'package_text_styling',
            [
                'label' => __('Pricing Package Text Styling', 'bizino'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'pricingplan_number_color',
            [
                'label' => __('Pricing Package Text Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .package-style3 .package-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'pricingplan_number_typography',
                'label' => __('Pricing Package Text Typography', 'bizino'),
                'selector' => '{{WRAPPER}} .package-style3 .package-text'
            ]
        );

        $this->add_responsive_control(
            'pricingplan_number_margin',
            [
                'label' => __('Pricing Package Text Margin', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .package-style3 .package-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'pricingplan_number_padding',
            [
                'label' => __('Pricing Package Text Padding', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .package-style3 .package-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        
        $this->start_controls_section(
            'button_text_styling',
            [
                'label' => __('Button Text Styling', 'bizino'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => __('Button Text Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .package-style3 .vs-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_control(
            'button_text_hover_color',
            [
                'label' => __('Button Text Hover Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .package-style3 .vs-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_text_typography',
                'label' => __('Button Text Typography', 'bizino'),
                'selector' => '{{WRAPPER}} .package-style3 .vs-btn'
            ]
        );

        $this->add_responsive_control(
            'button_text_margin',
            [
                'label' => __('Button Text Margin', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .package-style3 .vs-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_text_padding',
            [
                'label' => __('Button Text Padding', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .package-style3 .vs-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        
    }

    protected function render(){

        $settings = $this->get_settings_for_display();
        
        $this->add_render_attribute( 'button', 'class', 'vs-btn' );

        if( ! empty( $settings['pricingplan_button_url']['url'] ) ) {
            $this->add_render_attribute( 'button', 'href', esc_url( $settings['pricingplan_button_url']['url'] ) );
        }

        if( ! empty( $settings['pricingplan_button_url']['nofollow'] ) ) {
            $this->add_render_attribute( 'button', 'rel', 'nofollow' );
        }

        if( ! empty( $settings['pricingplan_button_url']['is_external'] ) ) {
            $this->add_render_attribute( 'button', 'target', '_blank' );
        }

        $active = $settings['make_active'] == 'yes' ? 'active' : '';
        
        echo '<div class="package-style3 '.$active.'">';
            echo '<div class="package-head">';
                if( ! empty( $settings['pricing_plan_image']['url'] ) ){
                    echo '<div class="package-icon">';
                        echo techbiz_img_tag( array(
                            'url'   => esc_url( $settings['pricing_plan_image']['url'] ),
                        ) );
                    echo '</div>';
                }
                if( ! empty( $settings['pricingplan_name'] ) ){
                    echo '<h3 class="package-title">'.esc_html( $settings['pricingplan_name'] ).'</h3>';
                }
            echo '</div>';
            if( ! empty( $settings['pricingplan_subtext'] ) ){
                echo '<p class="package-text">'.esc_html( $settings['pricingplan_subtext'] ).'</p>';
            }
            if( ! empty( $settings['pricingplan_amount'] ) ){
                echo '<p class="package-price">'.wp_kses_post( $settings['pricingplan_amount'] ).'</p>';
            }
            if( ! empty( $settings['pricingplan_button_text'] ) ){
                echo '<a '.$this->get_render_attribute_string('button').'>';
                    echo esc_html( $settings['pricingplan_button_text'] );
                echo '</a>';
            }
            if( ! empty( $settings['pricingplan_desc_sub'] ) ){
                echo '<p class="package-subtitle">'.esc_html( $settings['pricingplan_desc_sub'] ).'</p>';
            }
            if( ! empty( $settings['pricingplan_description'] ) ){
                echo '<div class="package-features">';
                    echo wp_kses_post( $settings['pricingplan_description'] );
                echo '</div>';
            }
        echo '</div>';
        
    }
}

Plugin::instance()->widgets_manager->register( new Bizino_Pricing_Plan() );