<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Team Widget .
 *
 */
class Techbiz_Team_Member extends Widget_Base {

	public function get_name() {
		return 'techbizteammember';
	}

	public function get_title() {
		return __( 'Team Member', 'techbiz' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'techbiz' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'image_section',
			[
				'label'     => __( 'Team Member', 'techbiz' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'team_style',
			[
				'label' 		=> __( 'Team Style', 'techbiz' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  			=> __( 'Slider', 'techbiz' ),
					'2' 			=> __( 'Grid', 'techbiz' )
				],
			]
		);

		$this->add_control(
			'slider_style',
			[
				'label' 		=> __( 'Style', 'techbiz' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  			=> __( 'Style One', 'techbiz' ),
					'2' 			=> __( 'Style Two', 'techbiz' ),
					'3' 			=> __( 'Style Three', 'techbiz' ),
					'4' 			=> __( 'Style Four', 'techbiz' ),
				],
			]
		);

		$repeater = new Repeater();

        $repeater->add_control(
			'team_member_image',
			[
				'label'     => __( 'Team Member Image', 'techbiz' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        $repeater->add_control(
			'person_name',
            [
				'label'         => __( 'Person Name', 'techbiz' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'John Steven' , 'techbiz' ),
				'label_block'   => true,
			]
		);
		$repeater->add_control(
			'person_details_url',
			[
				'label' 		=> __( 'Person Details Url', 'techbiz' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'techbiz' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
        $repeater->add_control(
			'person_designation',
            [
				'label'         => __( 'Person Designation', 'techbiz' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Founder' , 'techbiz' ),
				'label_block'   => true,
			]
		);
		$repeater->add_control(
			'social_icon_one',
			[
				'label' 		=> __( 'Social Icon One', 'techbiz' ),
				'type' 			=> Controls_Manager::ICONS,
				'default' 		=> [
					'value' 		=> 'fab fa-facebook-f',
					'library' 		=> 'solid',
				],
			]
		);
		$repeater->add_control(
			'social_icon_one_link',
			[
				'label' 		=> __( 'Social Icon Link One', 'techbiz' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'techbiz' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> 'www.facebook.com',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
		$repeater->add_control(
			'social_icon_two',
			[
				'label' 		=> __( 'Social Icon Two', 'techbiz' ),
				'type' 			=> Controls_Manager::ICONS,
				'default' 		=> [
					'value' 		=> 'fab fa-twitter',
					'library' 		=> 'solid',
				],
			]
		);
		$repeater->add_control(
			'social_icon_two_link',
			[
				'label' 		=> __( 'Social Icon Link Two', 'techbiz' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'techbiz' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> 'www.twitter.com',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
		$repeater->add_control(
			'social_icon_three',
			[
				'label' 		=> __( 'Social Icon Three', 'techbiz' ),
				'type' 			=> Controls_Manager::ICONS,
				'default' 		=> [
					'value' 		=> 'fab fa-instagram',
					'library' 		=> 'solid',
				],
			]
		);
		$repeater->add_control(
			'social_icon_three_link',
			[
				'label' 		=> __( 'Social Icon Link Three', 'techbiz' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'techbiz' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> 'www.instagram.com',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
		$repeater->add_control(
			'social_icon_four',
			[
				'label' 		=> __( 'Social Icon Four', 'techbiz' ),
				'type' 			=> Controls_Manager::ICONS,
				'default' 		=> [
					'value' 		=> 'fab fa-instagram',
					'library' 		=> 'solid',
				],
			]
		);
		$repeater->add_control(
			'social_icon_four_link',
			[
				'label' 		=> __( 'Social Icon Link Four', 'techbiz' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'techbiz' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> 'www.instagram.com',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
		$repeater->add_control(
			'social_icon_five',
			[
				'label' 		=> __( 'Social Icon Five', 'techbiz' ),
				'type' 			=> Controls_Manager::ICONS,
				'default' 		=> [
					'value' 		=> 'fab fa-instagram',
					'library' 		=> 'solid',
				],
			]
		);
		$repeater->add_control(
			'social_icon_five_link',
			[
				'label' 		=> __( 'Social Icon Link Five', 'techbiz' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'techbiz' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> 'www.instagram.com',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Team Member', 'techbiz' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'image' 	=> Utils::get_placeholder_image_src(),
					],
					[
						'image' 	=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{person_name}}',
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'techbiz' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'slide_to_show',
			[
				'label' 		=> __( 'Slide To Show', 'techbiz' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 10,
						'step'			=> 1,
					],
				],
				'default' 	=> [
					'unit' 		=> 'px',
					'size' 		=> 3,
				],
			]
		);
        $this->end_controls_section();

		$this->start_controls_section(
			'general',
			[
				'label' 	=> __( 'General', 'techbiz' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'social_icon_color',
			[
				'label' 		=> __( 'Social Icon Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-style2 .team-social a,{{WRAPPER}} .team-style1 .team-social a' => 'color: {{VALUE}}',
                ]
			]
        );

		$this->add_control(
			'social_icon_hover_color',
			[
				'label' 		=> __( 'Social Icon Hover Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-style2 .team-social a:hover i,{{WRAPPER}} .team-style1 .team-social a:hover i' => 'color: {{VALUE}}',
                ]
			]
        );

		$this->add_control(
			'social_icon_bg_color',
			[
				'label' 		=> __( 'Social Icon Bg Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-style2 .team-social,{{WRAPPER}} .team-style1 .team-social' => 'background-color: {{VALUE}}',
                ]
			]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'team_member_style_option',
			[
				'label' 	=> __( 'Team Member Style', 'techbiz' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'person_name_color',
			[
				'label' 		=> __( 'Person Name Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-style1 .team-title a,{{WRAPPER}} .team-style2 .team-title a' => 'color: {{VALUE}}',
                ]
			]
        );
		$this->add_control(
			'person_name_color_hover',
			[
				'label' 		=> __( 'Person Name Color Hover', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-style1 .team-title a:hover,{{WRAPPER}} .team-style2 .team-title a:hover' => 'color: {{VALUE}}',
                ]
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'          => 'person_name_typography',
				'label'         => __( 'Person Name Typography', 'techbiz' ),
                'selector'      => '{{WRAPPER}} .team-style1 .team-title,{{WRAPPER}} .team-style2 .team-title',
			]
		);
        $this->add_responsive_control(
			'person_name_margin',
			[
				'label'         => __( 'Person Name Margin', 'techbiz' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .team-style1 .team-title,{{WRAPPER}} .team-style2 .team-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
			'person_name_padding',
			[
				'label'         => __( 'Person Name Padding', 'techbiz' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .team-style1 .team-title,{{WRAPPER}} .team-style2 .team-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'separator'		=> 'after',
			]
		);
		$this->add_control(
			'person_designation_color',
			[
				'label' 		=> __( 'Person Designation Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-style1 .team-degi,{{WRAPPER}} .team-style2 .team-degi' => 'color: {{VALUE}}',
                ]
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'          => 'person_designation_typography',
				'label'         => __( 'Person Designation Typography', 'techbiz' ),
                'selector'      => '{{WRAPPER}} .team-style1 .team-degi,{{WRAPPER}} .team-style2 .team-degi',
			]
		);
        $this->add_responsive_control(
			'person_designation_margin',
			[
				'label'         => __( 'Person Designation Margin', 'techbiz' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .team-style1 .team-degi,{{WRAPPER}} .team-style2 .team-degi' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
			'person_designation_padding',
			[
				'label'         => __( 'Person Designation Padding', 'techbiz' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .team-style1 .team-degi,{{WRAPPER}} .team-style2 .team-degi' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);
		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['team_style'] == '1' ){
			$this->add_render_attribute( 'wrapper', 'class', 'row vs-carousel' );
			if( $settings['slider_style'] == '4' ){
				$this->add_render_attribute( 'wrapper', 'class', 'team-zigzag' );
			}
		}else{
			$this->add_render_attribute( 'wrapper', 'class', 'row' );
		}
		$this->add_render_attribute( 'wrapper', 'data-slick-arrows', 'false' );
		$this->add_render_attribute( 'wrapper', 'data-slick-autoplay', 'false' );
		$this->add_render_attribute( 'wrapper', 'data-slide-to-show', $settings['slide_to_show']['size'] );
		
		if( $settings['slider_style'] == '4' ){
			$container = "container container-style3";
		}else{
			$container = "container";
		}

		if( ! empty( $settings['slides'] ) ){
			echo '<section class="vs-team-wrapper">';
		        echo '<div class="'.esc_attr( $container ).'">';
					echo '<div '.$this->get_render_attribute_string('wrapper').'>';
						foreach( $settings['slides'] as $team_member ){
							$target_team 	= $team_member['person_details_url']['is_external'] ? ' target="_blank"' : '';
							$nofollow_team 	= $team_member['person_details_url']['nofollow'] ? ' rel="nofollow"' : '';
							// Icon One
							$target_social_one 		= $team_member['social_icon_one_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow_social_one 	= $team_member['social_icon_one_link']['nofollow'] ? ' rel="nofollow"' : '';
							// Icon Two
							$target_social_two 		= $team_member['social_icon_two_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow_social_two 	= $team_member['social_icon_two_link']['nofollow'] ? ' rel="nofollow"' : '';
							// Icon Three
							$target_social_three 	= $team_member['social_icon_three_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow_social_three 	= $team_member['social_icon_three_link']['nofollow'] ? ' rel="nofollow"' : '';
							// Icon Four
							$target_social_four 	= $team_member['social_icon_four_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow_social_four 	= $team_member['social_icon_four_link']['nofollow'] ? ' rel="nofollow"' : '';
							// Icon Five
							$target_social_five 	= $team_member['social_icon_five_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow_social_five 	= $team_member['social_icon_five_link']['nofollow'] ? ' rel="nofollow"' : '';
							
							if( $settings['slider_style'] == '4' ){
								$class = "team-style3";
							}else{
								$class = "";
							}
							
							echo '<div class="col-md-6 col-lg-4 col-xl-3 '.esc_attr( $class ).'">';
								if( $settings['slider_style'] == '1' || $settings['slider_style'] == '3' ){
									if( $settings['slider_style'] == '3' ){
										$layout = "layout2";
									}else{
										$layout = "";
									}
									echo '<div class="team-style1 '.esc_attr( $layout ).'">';
				                        echo '<div class="team-img">';
											if( ! empty( $team_member['team_member_image']['url'] ) ){
					                            echo '<a '.wp_kses_post( $target_team.$nofollow_team ).' href="'.esc_url( $team_member['person_details_url']['url'] ).'">';
													echo techbiz_img_tag( array(
														'url'	=> esc_url( $team_member['team_member_image']['url'] ),
													) );
												echo '</a>';
											}
				                            echo '<div class="team-social">';
												if( !empty( $team_member['social_icon_one']['value'] ) ){
													echo '<a '.wp_kses_post( $target_social_one.$nofollow_social_one ).' href="'.esc_url( $team_member['social_icon_one_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_one']['value'] ).'"></i></a>';
												}
												if( !empty( $team_member['social_icon_two']['value'] ) ){
													echo '<a '.wp_kses_post( $target_social_two.$nofollow_social_two ).' href="'.esc_url( $team_member['social_icon_two_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_two']['value'] ).'"></i></a>';
												}
												if( !empty( $team_member['social_icon_three']['value'] ) ){
													echo '<a '.wp_kses_post( $target_social_three.$nofollow_social_three ).' href="'.esc_url( $team_member['social_icon_three_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_three']['value'] ).'"></i></a>';
												}
												if( !empty( $team_member['social_icon_four']['value'] ) ){
													echo '<a '.wp_kses_post( $target_social_four.$nofollow_social_four ).' href="'.esc_url( $team_member['social_icon_four_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_four']['value'] ).'"></i></a>';
												}
												if( !empty( $team_member['social_icon_five']['value'] ) ){
													echo '<a '.wp_kses_post( $target_social_five.$nofollow_social_five ).' href="'.esc_url( $team_member['social_icon_five_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_five']['value'] ).'"></i></a>';
												}
				                            echo '</div>';
				                        echo '</div>';
				                        echo '<div class="team-content">';
											if( ! empty( $team_member['person_name'] ) ){
												echo '<h3 class="team-title"><a class="text-inherit" '.wp_kses_post( $target_team.$nofollow_team ).' href="'.esc_url( $team_member['person_details_url']['url'] ).'">'.esc_html( $team_member['person_name'] ).'</a></h3>';
											}
											if( ! empty( $team_member['person_designation'] ) ){
												echo '<p class="team-degi">'.esc_html( $team_member['person_designation'] ).'</p>';
											}
				                        echo '</div>';
				                    echo '</div>';
								}elseif( $settings['slider_style'] == '2' ){
									echo '<div class="team-style2">';
				                        echo '<div class="team-img">';
				                            echo '<div class="team-shape1"></div>';
				                            echo '<div class="team-shape2"></div>';
												if( ! empty( $team_member['team_member_image']['url'] ) ){
						                            echo '<a '.wp_kses_post( $target_team.$nofollow_team ).' href="'.esc_url( $team_member['person_details_url']['url'] ).'">';
														echo techbiz_img_tag( array(
															'url'	=> esc_url( $team_member['team_member_image']['url'] ),
														) );
													echo '</a>';
												}
				                            echo '<div class="team-social">';
												if( !empty( $team_member['social_icon_one']['value'] ) ){
													echo '<a '.wp_kses_post( $target_social_one.$nofollow_social_one ).' href="'.esc_url( $team_member['social_icon_one_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_one']['value'] ).'"></i></a>';
												}
												if( !empty( $team_member['social_icon_two']['value'] ) ){
													echo '<a '.wp_kses_post( $target_social_two.$nofollow_social_two ).' href="'.esc_url( $team_member['social_icon_two_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_two']['value'] ).'"></i></a>';
												}
												if( !empty( $team_member['social_icon_three']['value'] ) ){
													echo '<a '.wp_kses_post( $target_social_three.$nofollow_social_three ).' href="'.esc_url( $team_member['social_icon_three_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_three']['value'] ).'"></i></a>';
												}
												if( !empty( $team_member['social_icon_four']['value'] ) ){
													echo '<a '.wp_kses_post( $target_social_four.$nofollow_social_four ).' href="'.esc_url( $team_member['social_icon_four_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_four']['value'] ).'"></i></a>';
												}
												if( !empty( $team_member['social_icon_five']['value'] ) ){
													echo '<a '.wp_kses_post( $target_social_five.$nofollow_social_five ).' href="'.esc_url( $team_member['social_icon_five_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_five']['value'] ).'"></i></a>';
												}
				                            echo '</div>';
				                        echo '</div>';
				                        echo '<div class="team-content">';
											if( ! empty( $team_member['person_name'] ) ){
												echo '<h3 class="team-title h5"><a class="text-inherit" '.wp_kses_post( $target_team.$nofollow_team ).' href="'.esc_url( $team_member['person_details_url']['url'] ).'">'.esc_html( $team_member['person_name'] ).'</a></h3>';
											}
											if( ! empty( $team_member['person_designation'] ) ){
												echo '<p class="team-degi">'.esc_html( $team_member['person_designation'] ).'</p>';
											}
				                        echo '</div>';
				                    echo '</div>';
								}elseif( $settings['slider_style'] == '4' ){
				                    echo '<div class="team-img">';
										if( ! empty( $team_member['team_member_image']['url'] ) ){
											echo '<a '.wp_kses_post( $target_team.$nofollow_team ).' href="'.esc_url( $team_member['person_details_url']['url'] ).'">';
												echo techbiz_img_tag( array(
													'url'	=> esc_url( $team_member['team_member_image']['url'] ),
												) );
											echo '</a>';
										}
				                    echo '</div>';
				                    echo '<div class="team-content">';
										if( ! empty( $team_member['person_name'] ) ){
											echo '<h3 class="team-title"><a class="text-inherit" '.wp_kses_post( $target_team.$nofollow_team ).' href="'.esc_url( $team_member['person_details_url']['url'] ).'">'.esc_html( $team_member['person_name'] ).'</a></h3>';
										}
										if( ! empty( $team_member['person_designation'] ) ){
											echo '<p class="team-degi">'.esc_html( $team_member['person_designation'] ).'</p>';
										}
				                        echo '<div class="team-social">';
											if( !empty( $team_member['social_icon_one']['value'] ) ){
												echo '<a '.wp_kses_post( $target_social_one.$nofollow_social_one ).' href="'.esc_url( $team_member['social_icon_one_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_one']['value'] ).'"></i></a>';
											}
											if( !empty( $team_member['social_icon_two']['value'] ) ){
												echo '<a '.wp_kses_post( $target_social_two.$nofollow_social_two ).' href="'.esc_url( $team_member['social_icon_two_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_two']['value'] ).'"></i></a>';
											}
											if( !empty( $team_member['social_icon_three']['value'] ) ){
												echo '<a '.wp_kses_post( $target_social_three.$nofollow_social_three ).' href="'.esc_url( $team_member['social_icon_three_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_three']['value'] ).'"></i></a>';
											}
											if( !empty( $team_member['social_icon_four']['value'] ) ){
												echo '<a '.wp_kses_post( $target_social_four.$nofollow_social_four ).' href="'.esc_url( $team_member['social_icon_four_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_four']['value'] ).'"></i></a>';
											}
											if( !empty( $team_member['social_icon_five']['value'] ) ){
												echo '<a '.wp_kses_post( $target_social_five.$nofollow_social_five ).' href="'.esc_url( $team_member['social_icon_five_link']['url'] ).'"><i class="'.esc_attr( $team_member['social_icon_five']['value'] ).'"></i></a>';
											}
				                        echo '</div>';
				                    echo '</div>';
								}
			                echo '</div>';
						}
		            echo '</div>';
		        echo '</div>';
			echo '</section>';
		}
	}
}