<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Pricing Table Widget .
 *
 */
class Techbiz_Pricing_Table extends Widget_Base {

	public function get_name() {
		return 'techbizpricingtable';
	}

	public function get_title() {
		return __( 'Pricing Table', 'techbiz' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'techbiz' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'pricing_table_section',
			[
				'label' 	=> __( 'Pricing Table', 'techbiz' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$repeater = new Repeater();

        $repeater->add_control(
			'pricing_plan_name',
			[
				'label' 	=> __( 'Pricing Plan Name', 'techbiz' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Basic', 'techbiz' )
			]
        );

        $repeater->add_control(
			'item_price',
			[
				'label' 	=> __( 'Item Price', 'techbiz' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( '$27.99', 'techbiz' ),
			]
        );

        $repeater->add_control(
			'item_price_time',
			[
				'label' 	=> __( 'Item Price Time', 'techbiz' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( '/monthly', 'techbiz' ),
			]
        );

        $repeater->add_control(
			'item_description',
			[
				'label'         => __( 'Description', 'techbiz' ),
				'type'          => Controls_Manager::WYSIWYG,
				'default'       => __( 'Default description', 'techbiz' ),
				'placeholder'   => __( 'Type your description here', 'techbiz' ),
			]
		);

        $repeater->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'techbiz' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Get Started', 'techbiz' )
			]
        );

        $repeater->add_control(
			'button_icon_class',
			[
				'label' 	=> __( 'Button Icon Class', 'techbiz' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'far fa-arrow-right', 'techbiz' ),
			]
        );

        $repeater->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'techbiz' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'techbiz' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'techbiz' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'item_price' 			=> __( '$27.99', 'techbiz' ),
						'pricing_plan_name' 	=> __( 'Basic Plan', 'techbiz' ),
					],
					[
						'item_price' 			=> __( '$37.99', 'techbiz' ),
						'pricing_plan_name' 	=> __( 'Silver Plan', 'techbiz' ),
					],
					[
						'item_price' 			=> __( '$47.99', 'techbiz' ),
						'pricing_plan_name' 	=> __( 'Gold Plan', 'techbiz' ),
					],
					[
						'item_price' 			=> __( '$97.99', 'techbiz' ),
						'pricing_plan_name' 	=> __( 'VIP Plan', 'techbiz' ),
					],
				],
				'title_field' 	=> '{{{ pricing_plan_name }}}',
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'techbiz' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'slide_to_show',
			[
				'label' 		=> __( 'Slide To Show', 'techbiz' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 10,
						'step'			=> 1,
					],
				],
				'default' 	=> [
					'unit' 		=> 'px',
					'size' 		=> 3,
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'pricing_table_style_section',
			[
				'label' 	=> __( 'Pricing Table Style', 'techbiz' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'project_bg_image',
			[
				'label' 	=> esc_html__( 'Project Bg Image', 'techbiz' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' 	=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
			'pricing_table_color',
			[
				'label' 		=> __( 'Pricing Title Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .price-style1 .price-package' => 'color: {{VALUE}}!important',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'pricing_table_typography',
				'label' 	=> __( 'Pricing Title Typography', 'techbiz' ),
                'selector' 	=> '{{WRAPPER}} .price-style1 .price-package',
			]
        );

        $this->add_responsive_control(
			'pricing_table_margin',
			[
				'label' 		=> __( 'Pricing Title Margin', 'techbiz' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .price-style1 .price-package' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'pricing_table_padding',
			[
				'label' 		=> __( 'Pricing Title Padding', 'techbiz' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .price-style1 .price-package' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'separator'		=> 'after',
			]
		);

		$this->add_control(
			'plan_price_color',
			[
				'label' 		=> __( 'Plan Price Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .price-style1 .price-amount' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'plan_price_typography',
				'label' 	=> __( 'Plan Price Typography', 'techbiz' ),
                'selector' 	=> '{{WRAPPER}} .price-style1 .price-amount',
			]
        );

		$this->add_control(
			'plan_list_color',
			[
				'label' 		=> __( 'Plan List Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .price-style1 .price-features ul' => 'color: {{VALUE}}',
                ],
				'separator'		=> 'before',
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'plan_list_typography',
				'label' 	=> __( 'Plan List Typography', 'techbiz' ),
                'selector' 	=> '{{WRAPPER}} .price-style1 .price-features ul',
			]
        );

		$this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Button Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn' => 'color: {{VALUE}}',
                ],
				'separator'		=> 'before',
			]
        );

        $this->add_control(
			'button_color_hover',
			[
				'label' 		=> __( 'Button Color Hover', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn:hover' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_color',
			[
				'label' 		=> __( 'Button Background Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn' => 'background-color: {{VALUE}}',
                ],
			]
        );
        $this->add_control(
			'button_bg_color_hover',
			[
				'label' 		=> __( 'Button Background Hover Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn::before,{{WRAPPER}} .vs-btn::after' => 'background-color: {{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border',
				'label' 	=> __( 'Border', 'techbiz' ),
                'selector' 	=> '{{WRAPPER}} .vs-btn',
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Button Typography', 'techbiz' ),
                'selector' 	=> '{{WRAPPER}} .vs-btn',
			]
        );

        $this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Button Margin', 'techbiz' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Button Padding', 'techbiz' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->add_responsive_control(
			'button_border_radius',
			[
				'label' 		=> __( 'Button Border Radius', 'techbiz' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' 		=> 'box_shadow',
				'label' 	=> __( 'Box Shadow', 'techbiz' ),
				'selector' 	=> '{{WRAPPER}} .vs-btn',
			]
		);

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

		$this->add_render_attribute( 'wrapper', 'class', 'row vs-carousel' );
		$this->add_render_attribute( 'wrapper', 'data-slick-arrows', 'false' );
		$this->add_render_attribute( 'wrapper', 'data-slick-autoplay', 'false' );
		$this->add_render_attribute( 'wrapper', 'data-slide-to-show', $settings['slide_to_show']['size'] );

		echo '<div class="pricing-wrapper">';
    		echo '<div class="container">';
    			echo '<div '.$this->get_render_attribute_string('wrapper').'>';
    				foreach( $settings['slides'] as $singleslide ) {
						echo '<div class="col-xl-4">';
		                    echo '<div class="price-style1">';
								if( ! empty( $settings['project_bg_image']['url'] ) ){
			                        echo '<div class="price-shape" data-bg-src="'.esc_url( $settings['project_bg_image']['url'] ).'"></div>';
								}
								if( ! empty( $singleslide['pricing_plan_name'] ) ){
			                        echo '<h3 class="price-package h5">'.esc_html( $singleslide['pricing_plan_name'] ).'</h3>';
								}
								if( ! empty( $singleslide['item_price'] ) || ! empty( $singleslide['item_price_time'] ) ){
			                        echo '<div class="price-amount h1">'.esc_html( $singleslide['item_price'] ).'<span class="price-duration">'.esc_html( $singleslide['item_price'] ).'</span></div>';
								}
		                        echo '<div class="price-features">';
		                           echo wp_kses_post( $singleslide['item_description'] );
		                        echo '</div>';
								if( ! empty( $singleslide['button_text'] ) ){
			                        echo '<a href="'.esc_url( $singleslide['button_link']['url'] ).'" class="vs-btn">';
										echo esc_html( $singleslide['button_text'] );
										echo '<i class="'.esc_attr( $singleslide['button_icon_class'] ).'"></i>';
									echo '</a>';
								}
		                    echo '</div>';
		                echo '</div>';
    				}
    			echo '</div>';
    		echo '</div>';
		echo '</div>';

	}
}